<?php
/**
 * Konfiguracija baze podataka
 * 
 * Datoteka: db_config.php
 * Opis: Sadrži podatke za spajanje na MySQL bazu podataka
 */

// Definiranje osnovnih putanja
define('BASE_PATH', '/var/www/html/');  // Glavni web direktorij
define('APP_PATH', BASE_PATH);          // Putanja do aplikacije
define('UPLOADS_PATH', APP_PATH . 'uploads/'); // Putanja do uploads direktorija
define('LOGS_PATH', APP_PATH . 'logs/'); // Putanja do logs direktorija

// Stvaranje potrebnih direktorija ako ne postoje
if (!file_exists(UPLOADS_PATH)) {
    mkdir(UPLOADS_PATH, 0755, true);
}

if (!file_exists(LOGS_PATH)) {
    mkdir(LOGS_PATH, 0755, true);
}

// Podaci za spajanje na bazu
$db_host = 'localhost';
$db_user = 'baze';
$db_pass = 'K4qq3jniija2025SP@';
$db_name = 'mjerenjeproba';

// Stvaranje konekcije
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

// Provjera konekcije
if ($conn->connect_error) {
    die("Greška prilikom spajanja na bazu: " . $conn->connect_error);
}

// Postavljanje UTF-8 kodne stranice
$conn->set_charset("utf8");

/**
 * Funkcija za sigurno izvršavanje upita
 * 
 * @param string $sql SQL upit s placeholder-ima
 * @param array $params Parametri za upit
 * @return mysqli_stmt|false Prepared statement ili false u slučaju greške
 */
function executeQuery($sql, $params = []) {
    global $conn;
    
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        return false;
    }
    
    if (!empty($params)) {
        $types = '';
        $bindParams = [];
        
        // Određivanje tipova parametara
        foreach ($params as $param) {
            if (is_int($param)) {
                $types .= 'i';
            } elseif (is_float($param)) {
                $types .= 'd';
            } elseif (is_string($param)) {
                $types .= 's';
            } else {
                $types .= 'b';
            }
            
            $bindParams[] = $param;
        }
        
        // Referenca na parametre za bind_param
        $bindParamsRef = [];
        $bindParamsRef[] = &$types;
        
        for ($i = 0; $i < count($bindParams); $i++) {
            $bindParamsRef[] = &$bindParams[$i];
        }
        
        // Bindanje parametara
        call_user_func_array([$stmt, 'bind_param'], $bindParamsRef);
    }
    
    $stmt->execute();
    
    return $stmt;
}